# Odniesienia

## Rozdział 1. Wprowadzenie do Linuksa

[Happy birthday, Linux](https://www.theregister.com/2021/08/25/linux_kernel_30_years_old/)

[Linux Distributions Timeline](https://upload.wikimedia.org/wikipedia/commons/b/b5/Linux_Distribution_Timeline_21_10_2021.svg)

[Advanced Programming in the UNIX Environment](https://stevens.netmeister.org/631/)

[The Birth of UNIX With Brian Kernighan - CoRecursive Podcast](https://corecursive.com/brian-kernighan-unix-bell-labs1/)

[Fragmentation Is GOOD: Why We Still Need New Linux Distros](https://openforeveryone.net/articles/fragmentation-is-good-why-we-need-new-linux-distros/)


## Rozdział 2. Jądro Linuksa

[Lines of code in the Linux kernel : linux](https://www.reddit.com/r/linux/comments/9uxwli/lines_of_code_in_the_linux_kernel/)

[udoprog/kernelstats: Calculate Statistics about the Linux Kernel](https://github.com/udoprog/kernelstats)

[Interactive map of Linux kernel](https://makelinux.github.io/kernel/map/)

[Driver Model — The Linux Kernel documentation](https://www.kernel.org/doc/html/latest/driver-api/driver-model/index.html)

[System calls · Linux Inside](https://0xax.gitbooks.io/linux-insides/content/SysCall/)

[Interrupts on Linux](https://www.cs.montana.edu/courses/spring2005/518/Hypertextbook/jim/media/interrupts_on_linux.pdf)

[System Calls — The Linux Kernel documentation](https://linux-kernel-labs.github.io/refs/heads/master/lectures/syscalls.html)

[CPU Architectures — The Linux Kernel documentation](https://www.kernel.org/doc/html/latest/arch.html)

[Linux Device Drivers, Second Edition - LWN.net](https://lwn.net/Kernel/LDD2/ch16.lwn)

[Important parts of the kernel](https://tldp.org/LDP/sag/html/kernel-parts.html#:~:text=The%20Linux%20kernel%20consists%20of,various%20other%20bits%20and%20pieces.)

[`io_uring` is not an event system](https://despairlabs.com/posts/2021-06-16-io-uring-is-not-an-event-system/)

[Ch2: Practical Safe Linux Kernel Extensibility](https://homes.cs.washington.edu/~arvind/papers/rust-ext.pdf)

[Ch2: kernel architectures](https://www.cs.cornell.edu/courses/cs614/2007fa/Slides/kernel%20architectures.pdf)

[Linux Kernel Teaching — The Linux Kernel documentation](https://linux-kernel-labs.github.io/refs/heads/master/index.html)

[Anatomy of the Linux kernel – IBM Developer](https://developer.ibm.com/articles/l-linux-kernel/)

[The Linux kernel: Processes](https://www.win.tue.nl/~aeb/linux/lk/lk-10.html)

[Kernel Newbies: Understanding the structure task_struct](https://www.spinics.net/lists/newbies/msg11186.html)

[l05-syscall-intr-linux.pdf](https://www.cs.columbia.edu/~junfeng/10sp-w4118/lectures/l05-syscall-intr-linux.pdf)

[List of Linux Syscalls](https://linuxhint.com/list_of_linux_syscalls/)

[Linux system calls](http://linasm.sourceforge.net/docs/syscalls/index.php)

[Understand the Linux VMM](https://www.kernel.org/doc/gorman/pdf/understand.pdf)

[Linux Memory Management](http://lass.cs.umass.edu/~shenoy/courses/spring20/lectures/Lec21.pdf)

[Linux Kernel 2.4 Internals](https://tldp.org/LDP/lki/lki.pdf)

[Linux Page Cache for SRE, Viacheslav Biriukov](https://biriukov.dev/docs/page-cache/0-linux-page-cache-for-sre/)

[Searchable Linux Syscall Table for x86 and x86_64](https://filippo.io/linux-syscall-table/)

[eBPF maps — Prototype Kernel 0.0.1 documentation](https://prototype-kernel.readthedocs.io/en/latest/bpf/ebpf_maps.html)

[Process states in Linux - Kernel Talks](https://kerneltalks.com/linux/process-states-in-linux/)


## Rozdział 3. Powłoki i skrypty

[Byobu - About](https://www.byobu.org/about)

[About Zellij](https://zellij.dev/about/)

[An introduction to terminal multiplexers - LinuxConfig.org](https://linuxconfig.org/an-introduction-to-terminal-multiplexers)

[About - Linux Systems Analyst, Hayden James](https://haydenjames.io/about-me/)

[Warp: the blazingly fast, Rust-based terminal](https://www.warp.dev/)

[Unix Shells: Bash, Fish, Ksh, Tcsh, Zsh - Hyperpolyglot](https://hyperpolyglot.org/unix-shells)

[Linux Command Line Adventure: Terminal Multiplexers](https://www.linuxcommand.org/lc3_adv_termmux.php)

[The TTY demystified](http://www.linusakesson.net/programming/tty/)

[Bash scripting cheatsheet](https://devhints.io/bash)

[Bash best practices: cheat-sheets](https://bertvv.github.io/cheat-sheets/Bash.html)

[RFC3339 Date and Time on the Internet](https://datatracker.ietf.org/doc/html/rfc3339)

[Regex cheatsheet](https://remram44.github.io/regex-cheatsheet/regex.html)

[`rr` shell script manager and runner](https://taarr.com/)

[a8m/envsubst: Environment variables substitution for Go](https://github.com/a8m/envsubst)

[Increasing productivity in tmux with a single prefix key, Guilherme Garnier](https://blog.guilhermegarnier.com/2017/12/increasing-productivity-in-tmux-with-a-single-prefix-key/)

[Ghost in the Shell – Part 7 – ZSH Setup](https://vermaden.wordpress.com/2021/09/19/ghost-in-the-shell-part-7-zsh-setup/)

[Anatomy of a Terminal Emulator :: poor.dev](https://www.poor.dev/blog/terminal-anatomy/)


## Rozdział 4. Kontrola dostępu

[Managing Users & Groups, File Permissions & Attributes](https://www.tecmint.com/manage-users-and-groups-in-linux/)

[An introduction to Linux Access Control Lists (ACLs)](https://www.redhat.com/sysadmin/linux-access-control-lists)

[POSIX Access Control Lists on Linux](https://www.usenix.org/legacy/publications/library/proceedings/usenix03/tech/freenix03/full_papers/gruenbacher/gruenbacher_html/main.html)

[Linux Capabilities: Why They Exist and How They Work](https://blog.container-solutions.com/linux-capabilities-why-they-exist-and-how-they-work)

[Linux Capabilities: making them work ols2008v1-pages-163-172.pdf](https://www.kernel.org/doc/ols/2008/ols2008v1-pages-163-172.pdf)

[Linux Capabilities - HackTricks](https://book.hacktricks.xyz/linux-unix/privilege-escalation/linux-capabilities)

[A Survey of Access Control Policies](https://www.cs.umd.edu/sites/default/files/scholarly_papers/ACrowell_1.pdf)

[Users, Groups, UIDs and GIDs on systemd Systems](https://systemd.io/UIDS-GIDS/)

[Keycloak](https://www.keycloak.org/)

[A seccomp overview - LWN.net](https://lwn.net/Articles/656307/)

[Improving Linux container security with seccomp](https://www.redhat.com/sysadmin/container-security-seccomp)

[Security/Sandbox/Seccomp - MozillaWiki](https://wiki.mozilla.org/Security/Sandbox/Seccomp)

[Sandboxing in Linux with zero lines of code](https://blog.cloudflare.com/sandboxing-in-linux-with-zero-lines-of-code/)

[Many approaches to sandboxing in Linux - Open Source For You](https://www.opensourceforu.com/2016/07/many-approaches-sandboxing-linux/)

[Access Control Lists - ArchWiki](https://wiki.archlinux.org/title/Access_Control_Lists)

[Access Control Lists in Linux](https://documentation.suse.com/sles/12-SP4/html/SLES-all/cha-security-acls.html)


## Rozdział 5. Systemy plików

[Understanding File System Superblock in Linux](https://www.slashroot.in/understanding-file-system-superblock-linux)

[Overview of the Linux Virtual File System](https://www.kernel.org/doc/html/latest/filesystems/vfs.html)

[LinuxVFS (COMSW4118 lecture, Kaustubh R. Joshi)](http://www.cs.columbia.edu/~krj/os/lectures/L21-LinuxVFS.pdf)

[Filesystems in the Linux kernel — The Linux Kernel documentation](https://www.kernel.org/doc/html/latest/filesystems/)

[A Linux user's guide to Logical Volume Management](https://opensource.com/business/16/9/linux-users-guide-lvm)

[Linux LVM Cheat Sheet](https://unixutils.com/lvm-cheat-sheet-quick-reference/)

[fstab - ArchWiki](https://wiki.archlinux.org/title/Fstab)

[Filesystem Hierarchy Standard](https://refspecs.linuxfoundation.org/FHS_3.0/fhs/index.html)

[Using the /dev and /proc file systems - Linux.com](https://www.linux.com/news/using-dev-and-proc-file-systems/)

[The /proc Filesystem — The Linux Kernel documentation](https://www.kernel.org/doc/html/latest/filesystems/proc.html)

[Tmpfs — The Linux Kernel documentation](https://www.kernel.org/doc/html/latest/filesystems/tmpfs.html)

[DebugFS — The Linux Kernel documentation](https://www.kernel.org/doc/html/latest/filesystems/debugfs.html)

[LKML: Christian Brauner on loopfs](https://lkml.org/lkml/2020/4/8/506)

[The SWAPFS file system](https://linux.die.net/EVMSUG/x3863.html)

[Linux NTFS Project](https://flatcap.org/linux-ntfs/misc.html)

[OpenZFS Documentation — OpenZFS documentation](https://openzfs.github.io/openzfs-docs/)

[Filesystems Benchmarked » Linux Magazine](https://www.linux-magazine.com/Online/Features/Filesystems-Benchmarked)

[Overlay Filesystem — The Linux Kernel documentation](https://www.kernel.org/doc/html/latest/filesystems/overlayfs.html)

[btrfs Wiki](https://btrfs.wiki.kernel.org/index.php/Main_Page)

[Unionfs: A Stackable Unification File System](https://unionfs.filesystems.org/)

[Kernel Korner - Unionfs: Bringing Filesystems Together](https://www.linuxjournal.com/article/7714)

[Unifying filesystems with union mounts - LWN.net](https://lwn.net/Articles/312641/)

[Persistent BPF objects - LWN.net](https://lwn.net/Articles/664688/)


## Rozdział 6. Aplikacje, kontenery i zarządzanie pakietami

[systemd journal](https://docs.google.com/document/u/1/pub?id=1IC9yOXj7j6cdLLxWEBAGRL6wl97tFxgjLUEHIX3MSTs)

[The 7 most used Linux namespaces](https://www.redhat.com/sysadmin/7-linux-namespaces)

[DMVerity](https://gitlab.com/cryptsetup/cryptsetup/-/wikis/DMVerity)

[Systemd Essentials: Working with Services, Units, and the Journal](https://www.digitalocean.com/community/tutorials/systemd-essentials-working-with-services-units-and-the-journal)

[systemd/Journal - ArchWiki](https://wiki.archlinux.org/title/Systemd/Journal)

[Linux package managers: dnf vs apt](https://opensource.com/article/21/7/dnf-vs-apt)

[Understanding Systemd Units and Unit Files](https://www.digitalocean.com/community/tutorials/understanding-systemd-units-and-unit-files)

[How To Use Journalctl to View and Manipulate Systemd Logs](https://www.digitalocean.com/community/tutorials/how-to-use-journalctl-to-view-and-manipulate-systemd-logs)

[Managing Logging in Systemd](https://blog.selectel.com/managing-logging-systemd/)

[CPP / C++ - Package Managers](https://caiorss.github.io/C-Cpp-Notes/package-managers.html)

[What Is a Standard Container (2021 edition) - Ivan Velichko](https://iximiuz.com/en/posts/oci-containers/)

[Package Manager](https://devopedia.org/package-manager)

[systemd/Timers - ArchWiki](https://wiki.archlinux.org/title/Systemd/Timers)

[Dockerfile reference](https://docs.docker.com/engine/reference/builder/)

[The Quest for Minimal Docker Images, part 1](https://jpetazzo.github.io/2020/02/01/quest-minimal-docker-images-part-1/)

[Snap, Flatpak and AppImage, package formats compared](https://verummeum.com/portable-package-formats/#:~:text=Flatpak%20The%20Flatpak%20package%20format%20is%20developed%20as,can%20find%20the%20Flatpak%20source%20code%20on%20Github.)

[An Overview of Docker Desktop Alternatives](https://matt-rickard.com/docker-desktop-alternatives/)

[containerd](https://containerd.io/)

[Demystifying Containers – Part III: Container Images](https://www.suse.com/c/demystifying-containers-part-iii-container-images/)

[containers/skopeo](https://github.com/containers/skopeo)

[systemd Documentation](https://systemd.io/)

[rpm tutorial (2012)](https://access.redhat.com/sites/default/files/attachments/rpm_tutorial_20120831.pdf)

[Analyzing the Linux boot process](https://opensource.com/article/18/1/analyzing-linux-boot-process)

[Linux Package Management](https://www.linode.com/docs/guides/tools-reference/linux-package-management/)

[A series of blog posts and talks about the world of containers](https://github.com/saschagrunert/demystifying-containers)

[cgroups - ArchWiki](https://wiki.archlinux.org/title/Cgroups)

[Control Group v2 — The Linux Kernel documentation](https://www.kernel.org/doc/html/latest/admin-guide/cgroup-v2.html)

[The current adoption status of cgroup v2 in containers](https://medium.com/nttlabs/cgroup-v2-596d035be4d7)

[Use bind mounts](https://docs.docker.com/storage/bind-mounts/)

[The hunt for a better Dockerfile](https://matduggan.com/the-hunt-for-a-better-dockerfile/)

[Sonatype's 2021 State of the Software Supply Chain](https://www.sonatype.com/ssc2021)


## Rozdział 7. Sieć

[Linux Networking Documentation — The Linux Kernel documentation](https://www.kernel.org/doc/html/latest/networking/index.html)

[Anatomy of a Linux DNS Lookup – Part I – zwischenzugs](https://zwischenzugs.com/2018/06/08/anatomy-of-a-linux-dns-lookup-part-i/)

[OpenWrt Wiki: Linux Network Interfaces](https://openwrt.org/docs/guide-developer/networking/network.interfaces)

[How to Use the traceroute Command on Linux](https://www.howtogeek.com/657780/how-to-use-the-traceroute-command-on-linux/)

[(All) DNS Resource Records](https://www.netmeister.org/blog/dns-rrs.html)

[jonaslu/ain: An HTTP API client for the terminal](https://github.com/jonaslu/ain)

[Understanding network things in sketchnotes Series' Articles](https://dev.to/aurelievache/series/12360)

[5 years of Envoy OSS](https://mattklein123.dev/2021/09/14/5-years-envoy-oss/)

[orf/gping: Ping, but with a graph](https://github.com/orf/gping)

[Understanding Sockets](https://www.digitalocean.com/community/tutorials/understanding-sockets)

[Getting started with socat, a multipurpose relay tool for Linux](https://www.redhat.com/sysadmin/getting-started-socat)

[An Introduction to DNS Terminology, Components, and Concepts](https://www.digitalocean.com/community/tutorials/an-introduction-to-dns-terminology-components-and-concepts)

[IEEE 802.3-2018 - IEEE Standard for Ethernet](https://standards.ieee.org/standard/802_3-2018.html)

[IPv4 Subnetting and Special Purpose IP Addresses](https://www.meanservers.com/billing/knowledgebase/33/IPv4-Subnetting-and-Special-Purpose-IP-Addresses.html)

[CIDR.xyz](https://cidr.xyz/)

[tshark - The Wireshark Network Analyzer 3.4.8](https://www.wireshark.org/docs/man-pages/tshark.html)

[Linux Wireless](https://wireless.wiki.kernel.org/en/users/documentation/iw)

[What Is CIDR (Classless Inter-Domain Routing)? - KeyCDN Support](https://www.keycdn.com/support/what-is-cidr)

[projectdiscovery/mapcidr](https://github.com/projectdiscovery/mapcidr)

[IPv6 Weberblog.net](https://weberblog.net/ipv6/)

[IPv6 address types – APNIC](https://www.apnic.net/get-ip/faqs/what-is-an-ip-address/ipv6-address-types/)

[Linux IP Command Ultimate Tutorial with 31 Examples](https://phoenixnap.com/kb/linux-ip-command-examples)

[netfilter/iptables project homepage - The netfilter.org project](https://www.netfilter.org/)

[ISC Open Source Projects / BIND · GitLab](https://gitlab.isc.org/isc-projects/bind9)

[Main Page - Linux NFS](http://linux-nfs.org/wiki/index.php/Main_Page)

[Understanding IPv6 - 7 Part Series : Networking with FISH](https://www.networkingwithfish.com/understanding-ipv6-7-part-series/)

[Understanding How Facebook Disappeared from the Internet](https://blog.cloudflare.com/october-2021-facebook-outage/)

[Hello IPv6: a minimal tutorial for IPv4 users](https://metebalci.com/blog/hello-ipv6/)

[What is SSH Tunneling, SSH Reverse Tunneling and SSH Port Forwarding?](https://goteleport.com/blog/ssh-tunneling-explained/)

['BGP' by Iljitsch van Beijnum](http://www.bgpexpert.com/'BGP'-by-Iljitsch-van-Beijnum/)

[What's in a hostname?](https://www.netmeister.org/blog/hostnames.html)

[Everything about UDP sockets](https://blog.cloudflare.com/everything-you-ever-wanted-to-know-about-udp-sockets-but-were-afraid-to-ask-part-1/)


## Ch 8: Observability

[Linux Logging Complete Guide – devconnected](https://devconnected.com/linux-logging-complete-guide/)

[Linux Logs Explained - Full overview of Linux Log Files](https://www.plesk.com/blog/featured/linux-logs-explained/)

[Linux Performance Observability Tools](https://www.reddit.com/r/linux/comments/9va8jy/linux_performance_observability_tools/)

[Linux Performance Observability Tools](https://medium.com/@chrishantha/linux-performance-observability-tools-19ae2328f87f)

[vmtouch](https://hoytech.com/vmtouch/)

[Linux Performance](https://www.brendangregg.com/linuxperf.html)

[Systems Performance 2nd Edition Book](https://www.brendangregg.com/systems-performance-2nd-edition-book.html)

[Flame Graphs](https://www.brendangregg.com/flamegraphs.html)

[facebookincubator/below](https://github.com/facebookincubator/below)

[Glances - An Eye on your system](https://nicolargo.github.io/glances/)

[Tracing tutorial LF-2021](https://linuxfoundation.org/wp-content/uploads/ezannoni-tracing-tutorial-LF-2021.pdf)

[Linux tracing systems & how they fit together](https://jvns.ca/blog/2017/07/05/linux-tracing-systems/#ftrace)

[Nmon: Analyze and Monitor Linux System Performance](https://www.tecmint.com/nmon-analyze-and-monitor-linux-system-performance/)

[monit](https://mmonit.com/monit/)

[`top` based monitoring tools for use in Linux](https://drtailor.medium.com/a-curated-list-of-top-based-monitoring-tools-for-use-in-linux-and-unix-terminals-299154fd1394)

[Shopify/statsd-instrument: A StatsD client for Ruby apps](https://github.com/shopify/statsd-instrument)

[Learn StatsD Metrics Architecture, Metrics Types and Formats](https://sysdig.com/blog/monitoring-statsd-metrics/)

[Distributed tracing](https://microservices.io/patterns/observability/distributed-tracing.html)

[Linux Performance Analysis in 60,000 Milliseconds](https://netflixtechblog.com/linux-performance-analysis-in-60-000-milliseconds-accc10403c55)

[PabloLec/neoss: Unix tool with Terminal UI to visualize socket statistics.](https://github.com/PabloLec/neoss)

[iipeace/guider: Unified Performance Analyzer](https://github.com/iipeace/guider)

[MTR](http://www.bitwizard.nl/mtr/)

[google/pprof](https://github.com/google/pprof)

[Valgrind Home](https://www.valgrind.org/)

[syslog-ng/syslog-ng](https://github.com/syslog-ng/syslog-ng)

[rsyslog - ArchWiki](https://wiki.archlinux.org/title/Rsyslog)

[Practical Linux tracing part 4: tracing container workload](https://tungdam.medium.com/practical-linux-tracing-part-4-tracing-container-workload-63ac04306b27)

[Linux perf Profiler UIs](https://www.markhansen.co.nz/profiler-uis/)

[Profilerpedia: A map of the Software Profiling Ecosystem](https://www.markhansen.co.nz/profilerpedia/)

[Linux I/O Performance Tests using dd - Thomas-Krenn-Wiki](https://www.thomas-krenn.com/en/wiki/Linux_I/O_Performance_Tests_using_dd)

[evilsocket/uroboros](https://github.com/evilsocket/uroboros)


## Rozdział 9. Tematy zaawansowane

[a13xp0p0v/linux-kernel-defence-map: Linux Kernel Defence Map](https://github.com/a13xp0p0v/linux-kernel-defence-map)

[The Linux binfmt subsystem](https://anadoxin.org/blog/the-linux-binfmt-subsystem.html/)

[Pipes and Sockets](https://fog.ccsf.edu/~gboyd/cs260a/online/processes/pipes_and_sockets.html)

[Inter-process communication in Linux: Shared files and shared memory](https://opensource.com/article/19/4/interprocess-communication-linux-storage)

[Inter-process communication in Linux: Using pipes and message queues](https://opensource.com/article/19/4/interprocess-communication-linux-channels)

[The Linux Kernel Implementation of Pipes and FIFOs](https://www.slideshare.net/divyekapoor/linux-kernel-implementation-of-pipes-and-fifos)

[Socat Cheatsheet - blog.travismclarke.com](https://blog.travismclarke.com/post/socat-tutorial/)

[socat. I learned about socat a few years ago, Cindy Sridharan](https://copyconstruct.medium.com/socat-29453e9fc8a6)

[KVM](https://www.linux-kvm.org/page/Main_Page)

[Virtualization basics and an introduction to KVM](https://mkdev.me/en/posts/virtualization-basics-and-an-introduction-to-kvm)

[Flatcar Container Linux](https://thenewstack.io/flatcar-container-linux-the-ideal-os-for-running-kubernetes-at-the-edge/)

[bottlerocket-os/bottlerocket](https://github.com/bottlerocket-os/bottlerocket)

[rancher/os](https://github.com/rancher/os)

[Comparison of X window managers - Wikipedia](https://en.wikipedia.org/wiki/Comparison_of_X_window_managers)

[Desktop environment - ArchWiki](https://wiki.archlinux.org/title/Desktop_environment)

[Linux on embedded systems - Wikipedia](https://en.wikipedia.org/wiki/Linux_on_embedded_systems)

[NixOS: purely functional system configuration management - LWN.net](https://lwn.net/Articles/337677/)

[PAM Tutorial](http://wpollock.com/AUnix2/PAM-Help.htm)

[Kerberos](https://web.mit.edu/rhel-doc/5/RHEL-5-manual/Deployment_Guide-en-US/ch-kerberos.html)

[libvirt: The virtualization API](https://libvirt.org/)

[tuntap](https://www.kernel.org/doc/Documentation/networking/tuntap.txt)

[Kerberos: The Network Authentication Protocol](http://web.mit.edu/kerberos/)

[Nixos](https://edolstra.github.io/pubs/nixos-jfp-final.pdf)

[Purely Functional Linux with NixOS](https://begriffs.com/posts/2016-08-08-intro-to-nixos.html)

[How X Window Managers Work, And How To Write One (Part I)](https://jichu4n.com/posts/how-x-window-managers-work-and-how-to-write-one-part-i/)

[castrojo/awesome-immutable](https://github.com/castrojo/awesome-immutable)


## Dodatki

[collection of modern alternatives to common commands](https://github.com/ibraheemdev/modern-unix)

[joehillen/sysz](https://github.com/joehillen/sysz)

[BurntSushi/ripgrep](https://github.com/BurntSushi/ripgrep)

[ogham/exa](https://github.com/ogham/exa)

[dog](https://dns.lookup.dog/)

[ajeetdsouza/zoxide](https://github.com/ajeetdsouza/zoxide)

[kaplanelad/shellfirm](https://github.com/kaplanelad/shellfirm)

[antonmedv/fx](https://github.com/antonmedv/fx)

[jpmens/jo](https://github.com/jpmens/jo)
